<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\DepartmentDownload;
use App\Models\DepartmentDownloadFile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Intervention\Image\Facades\Image;
use App\Models\Course;
use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Models\User;
use App\Models\DownloadFile;
use Illuminate\Support\Facades\Hash;
use Brian2694\Toastr\Facades\Toastr;

class AdminDepartmentDownloadController extends Controller
{
    //Download View
    public function AdminDepartmentDownloadAllView()
    {
        Session::put('admin_page', 'admin_dpt_result_view');
        $download_date = DepartmentDownload::latest()->get();
        return view('admin.course_download.course_wise_download_view', compact('download_date'));
    }

    //Download add View
    public function AdminDepartmentDownloadAllAdd()
    {
        Session::put('admin_page', 'admin_dpt_result_view');
        $departments = Course::latest()->get();
        return view('admin.course_download.course_wise_download_add', compact('departments'));
    }

    //Download Add Store
    public function AdminDepartmentDownloadAllStore(Request $request)
    {
        $request->validate([
            'title' => 'required|max:255',
            'course_id' => 'required',
            'file' => 'required'
        ]);
        $userType = User::find(Auth::id());
        if ($userType->admin_type == "Author User") {
            $public = 1;
        } else {
            $public = 0;
        }
        $download_id = DepartmentDownload::insertGetId([
            'course_id' => $request->course_id,
            'user_id' => Auth::id(),
            'title' => $request->title,
            'title_slug' => Str::slug($request->title),
            'status' => 0,
            'public' => $public,
            'created_at' => Carbon::now(),



        ]);
        foreach ($request->file('file') as $file) {
            $filename = date('Y-m-s-H-i-') . $file->getClientOriginalName();
            $path = $file->store('./uploads/department_download_pdf/' . $filename);
            // do something with the file, such as store it in the database
            DepartmentDownloadFile::insert([
                'download_id' => $download_id,
                'file' => $path,
                'created_at' => Carbon::now(),
            ]);
        }
        Toastr::success('Download File Created Successfully');
        return redirect()->back();
    }

    //Notice Edit View
    public function AdminDepartmentDownloadAllEdit($id)
    {
        Session::put('admin_page', 'admin_dpt_result_view');
        $departments = Course::latest()->get();
        $download_edit = DepartmentDownload::find($id);
        return view('admin.course_download.course_wise_download_edit', compact('departments', 'download_edit'));
    }

    //Notice Update 

    public function AdminDepartmentDownloadAllUpdate(Request $request, $id)
    {
        $request->validate([
            'course_id' => 'required',
            'user_id' => "required",
            'title' => 'max:255|required',
            'download_id' => 'required',
        ]);
        $userType = User::find(Auth::id());
        if ($userType->admin_type == "Author User") {
            $public = 1;
        } else {
            $public = 0;
        }
        $download_id = DepartmentDownload::findOrFail($id)->update([
            'course_id' => $request->course_id,
            'user_id' => Auth::id(),
            'title' => $request->title,
            'title_slug' => Str::slug($request->title),
            'status' => 0,
            'public'=>$public,
            'created_at' => Carbon::now(),
        ]);
        if ($request->file('file')) {
            foreach ($request->file('file') as $file) {
                $filename = date('Y-m-s-H-i-') . $file->getClientOriginalName();
                $path = $file->store('./uploads/department_download_pdf/' . $filename);
                // do something with the file, such as store it in the database
                DepartmentDownloadFile::findOrFail($id)->update([
                    'download_id' => $download_id,
                    'file' => $path,
                    'created_at' => Carbon::now(),
                ]);
            }
        }
        Toastr::success('File Updated Successfully');
        return redirect()->back();
    }

    //Download File Edit Active
    public function AdminDepartmentDownloadAllActive($id)
    {
        DepartmentDownload::find($id)->update(['status' => 0]);
        Toastr::success('File Inactive Successfully');
        return redirect()->back();
    }

    //Download File  Inactive
    public function AdminDepartmentDownloadAllInactive($id)
    {
        DepartmentDownload::find($id)->update(['status' => 1]);
        Toastr::success('File Active Successfully');
        return redirect()->back();
    }

    // Download File delete
    public function AdminDepartmentDownloadAllDelete($id)
    {
        $unlinkData = DepartmentDownload::find($id)->delete();
        DepartmentDownloadFile::where('download_id', $id)->delete();
        @unlink($unlinkData->file);
        Toastr::success('File Deleted Successfully');
        return redirect()->back();
    }
}
