<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Course;
use Illuminate\Support\Facades\Auth;
use Intervention\Image\Facades\Image;
use App\Models\Download;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use App\Models\DownloadFile;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Brian2694\Toastr\Facades\Toastr;

class AdminDownloadController extends Controller
{
    //Download View
    public function AdminDownloadAllView()
    {
        Session::put('admin_page', 'admin_download_view');
        $download_date = Download::latest()->get();
        return view('admin.download.download_all_view', compact('download_date'));
    }

    //Download add View
    public function AdminDownloadAllAdd()
    {
        Session::put('admin_page', 'admin_download_view');
        $departments = Course::latest()->get();
        return view('admin.download.download_all_add', compact('departments'));
    }

    //Download Add Store
    public function AdminDownloadAllStore(Request $request)
    {
        $request->validate([
            'title'=>'required|max:255',
            'file'=>'required',
        ]);
        $userType = User::find(Auth::id());
        if ($userType->admin_type == "Author User") {
            $public = 1;
        } else {
            $public = 0;
        }
        $download_id = Download::insertGetId([
            'user_id' => Auth::id(),
            'title' => $request->title,
            'title_slug' => Str::slug($request->title),
            'status' => 0,
            'public'=>$public,
            'created_at' => Carbon::now(),
        ]);
        foreach ($request->file('file') as $file) {
            $filename = date('Y-m-s-H-i-') . $file->getClientOriginalName();
            $path = $file->store('./uploads/download_pdf/'.$filename);
            DownloadFile::insert([
                'download_id' => $download_id,
                'file' => $path,
                'created_at' => Carbon::now(),
            ]);
        }
        Toastr::success('Download File Created Successfully');
        return redirect()->back();
    }

    //Notice Edit View
    public function AdminDownloadAllEdit($id)
    {
        Session::put('admin_page', 'admin_download_view');
        $departments = Course::latest()->get();
        $download_edit = Download::find($id);
        return view('admin.download.download_all_edit', compact('departments', 'download_edit'));
    }

    //Notice Update 

    public function AdminDownloadAllUpdate(Request $request, $id)
    {
        $request->validate([
            'user_id' => "required",
            'title' => 'max:255|required',
            'file'=>'required',
        ]);
        $userType = User::find(Auth::id());
        if ($userType->admin_type == "Author User") {
            $public = 1;
        } else {
            $public = 0;
        }
        $download_id = Download::findOrFail($id)->update([
            'user_id' => Auth::id(),
            'title' => $request->title,
            'title_slug' => Str::slug($request->title),
            'status' => 0,
            'public'=>$public,
            'created_at' => Carbon::now(),
        ]);
        if ($request->file('file')) {
            foreach ($request->file('file') as $file) {
                $filename = date('Y-m-s-H-i-') . $file->getClientOriginalName();
                $path = $file->store('./uploads/download_pdf/'.$filename);
                // do something with the file, such as store it in the database
                DownloadFile::findOrFail($id)->update([
                    'download_id' => $download_id,
                    'file' => $path,
                    'created_at' => Carbon::now(),
                ]);
            }
        }
        Toastr::success('File Updated Successfully');
        return redirect()->back();
    }

    //Download File Edit Active
    public function AdminDownloadAllActive($id)
    {
        Download::find($id)->update(['status' => 0]);
        Toastr::success('File Inactive Successfully');
        return redirect()->back();
    }

    //Download File  Inactive
    public function AdminDownloadAllInactive($id)
    {
        Download::find($id)->update(['status' => 1]);
        Toastr::success('File Active Successfully');
        return redirect()->back();
    }

    // Download File delete
    public function AdminDownloadAllDelete($id)
    {
        $unlinkData = Download::find($id)->delete();
        DownloadFile::where('download_id', $id)->delete();
        @unlink($unlinkData->file);
        Toastr::success('File Deleted Successfully');
        return redirect()->back();
    }
}
