<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Entrance;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use App\Models\DownloadFile;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Hash;
use Brian2694\Toastr\Facades\Toastr;

class AdminEntranceController extends Controller
{
    //Admission View
    public function AdminEntranceView()
    {
        Session::put('admin_page', 'admin_entrance_view');
        $entrance = Entrance::latest()->get();
        return view('admin.entrance.entrance_view', compact('entrance'));
    }
     //Admission Add View
     public function AdminEntranceAdd()
     {
         return view('admin.entrance.entrance_add');
     }

     //Admission Store View
     public function AdminEntranceStore(Request $request)
     {
        $request->validate([
            'title' => 'max:255|required|unique:admissions,title',
            'para' => 'required',
        ]);
        $admission_store = new Entrance();
        $admission_store->title = $request->title;
        $admission_store->title_slug = Str::slug($request->title);
        $admission_store->para = $request->para;
        $admission_store->save();
        Toastr::success('Entrance Card Created Successfully');
        return redirect()->back();
     }
      //Admission Edit View
    public function AdminEntranceEdit($id)
    {
        $admission_edit = Entrance::find($id);
        return view('admin.entrance.entrance_edit', compact('admission_edit'));
    }

    //Admission Store View
    public function AdminEntranceUpdate(Request $request, $id)
    {
       $request->validate([
           'title' => 'max:255|required',
           'para' => 'required',
       ]);
       $admission_store = Entrance::find($id);
       $admission_store->title = $request->title;
       $admission_store->title_slug = Str::slug($request->title);
       $admission_store->para = $request->para;
       $admission_store->save();
       Toastr::success('Entrance Card Updated Successfully');
       return redirect()->back();
    }

     //Admission Store View
     public function AdminEntranceDelete($id)
     {
        $admission_delete = Entrance::find($id);
        $admission_delete->delete();
        Toastr::success('Entrance Card Deleted Successfully');
        return redirect()->back();
     }
}
