<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\NewsNotice;
use App\Models\User;
use App\Models\NewsNoticeImage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use Brian2694\Toastr\Facades\Toastr;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Auth;

class AdminNewsNoticeController extends Controller
{
    //News and Notice View
    public function AdminNewsNoticeView()
    {
        Session::put('admin_page', 'admin_notice_view');
        $news_notice = NewsNotice::latest()->get();
        return view('admin.news_notice.news_notice_view', compact('news_notice'));
    }

    //New and Notice Add View
    public function AdminNewsNoticeAdd()
    {
        Session::put('admin_page', 'admin_notice_view');
        return view('admin.news_notice.news_notice_add');
    }

    //News and Notice Store
    public function AdminNewsNoticeStore(Request $request)
    {
        $request->validate([
            'notice_title' => 'max:255|required',
            'notice_type' => 'required',
            'image' => 'required',
        ]);

        $userType = User::find(Auth::id());
        if ($userType->admin_type == "Author User") {
            $public = 1;
        } else {
            $public = 0;
        }
        $news_id = NewsNotice::insertGetId([
            'user_id' => Auth::id(),
            'notice_title' => $request->notice_title,
            'notice_type' => $request->notice_type,
            'public'=>$public,
            'created_at' => Carbon::now(),
        ]);
        $image = $request->file('image');
        foreach ($image as $img) {
            $make_name = hexdec(uniqid()) . '.' . $img->getClientOriginalExtension();
            Image::make($img)->save('./uploads/notice_news_image/' . $make_name);
            $uploadPath = './uploads/notice_news_image/' . $make_name;

            NewsNoticeImage::insert([
                'notice_id' => $news_id,
                'image' => $uploadPath,
                'created_at' => Carbon::now(),
            ]);
        }
        Toastr::success('News and Notice Add Successfully');

        return redirect()->back();
    }

    //News and Notice Edit View
    public function AdminNewsNoticeEdit($id)
    {
        Session::put('admin_page', 'admin_notice_view');
        $news_notice_edit = NewsNotice::find($id);
        return view('admin.news_notice.news_notice_edit', compact('news_notice_edit'));
    }




    //News Notice Image Update
    public function AdminNewsNoticeImageUpdate(Request $request)
    {
        $request->validate([
            'image'=>'required',
        ]);
        $image = $request->file('image');
        foreach ($image as $id => $img) {
            $imageDel = NewsNoticeImage::find($id);
            @unlink($imageDel->image);
            $make_name = hexdec(uniqid()) . '.' . $img->getClientOriginalExtension();
            Image::make($img)->save('./uploads/notice_news_image/' . $make_name);
            $uploadPath = './uploads/notice_news_image/' . $make_name;
            NewsNoticeImage::where('id', $id)->update([
                'image' => $uploadPath,
                'created_at' => Carbon::now(),
            ]);
        }
        Toastr::success('Image Updated Successfully');
        return redirect()->back();
    }


    //News Notice Image Delete
    public function AdminNewsNoticeImageDelete($id)
    {
        $old_img = NewsNoticeImage::find($id);
        @unlink($old_img->image);
        NewsNoticeImage::find($id)->delete();
        Toastr::success('Image Deleted Successfully');
        return redirect()->back();
    }

    //News and Notice Store
    public function AdminNewsNoticeUpdate(Request $request, $id)
    {
        $request->validate([
            'notice_title' => 'max:255|required',
            'notice_type' => 'required',
        ]);
        $userType = User::find(Auth::id());
        if ($userType->admin_type == "Author User") {
            $public = 1;
        } else {
            $public = 0;
        }
        NewsNotice::findOrFail($id)->update([
            'user_id' => Auth::id(),
            'notice_title' => $request->notice_title,
            'notice_type' => $request->notice_type,
            'public'=>$public,
            'created_at' => Carbon::now(),
        ]);

        Toastr::success('News and Notice Add Successfully');
        return redirect()->back();
    }

    public function AdminNewsNoticeDelete($id)
    {
        NewsNoticeImage::where('notice_id', $id)->delete();
        NewsNotice::findOrFail($id)->delete();
        Toastr::success('News and Notice Deleted Successfully');
        return redirect()->back();
    }
}
