<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\DepartmentDownload;
use App\Models\Download;
use App\Models\Event;
use App\Models\Gallery;
use App\Models\NewsNotice;
use Brian2694\Toastr\Facades\Toastr;

class AdminPremissionController extends Controller
{
    //Admin DPT Result Premission
    public function PremissionDPTResultView()
    {
        Session::put('admin_page', 'admin_dpt_result_view');

        $download_date = DepartmentDownload::where('public', 0)->paginate(10);
        return view('admin.premission.dpt_result_premission', compact('download_date'));
    }


    //Admin DPT Result Reject
    public function PremissionDPTResultReject($id)
    {
        $download = DepartmentDownload::find($id);
        $download->public = 2;
        $download->save();
        Toastr::success('Results Rejected Successfully');
        return redirect()->back();
    }


    //Admin DPT Result Reject
    public function PremissionDPTResultAccept($id)
    {
        $download = DepartmentDownload::find($id);
        $download->public = 1;
        $download->save();
        Toastr::success('Results Posted Successfully');
        return redirect()->back();
    }


    //Admin Download Premission
    public function PremissionDownloadView()
    {
        Session::put('admin_page', 'admin_download_view');
        $download_date = Download::where('public', 0)->latest()->get();
        return view('admin.premission.download_premission', compact('download_date'));
    }


    //Admin DPT Result Reject
    public function PremissionDownloadReject($id)
    {
        $download = Download::find($id);
        $download->public = 2;
        $download->save();
        Toastr::success('Results Rejected Successfully');
        return redirect()->back();
    }


    //Admin DPT Result Reject
    public function PremissionDownloadAccept($id)
    {
        $download = Download::find($id);
        $download->public = 1;
        $download->save();
        Toastr::success('Results Posted Successfully');
        return redirect()->back();
    }


    //Admin Gallery Premission
    public function PremissionNoticeView()
    {
        Session::put('admin_page', 'admin_notice_view');
        $news_notice = NewsNotice::where('public', 0)->latest()->get();
        return view('admin.premission.notice_premission', compact('news_notice'));
    }


    //Admin DPT Result Reject
    public function PremissionNoticeReject($id)
    {
        $download = NewsNotice::find($id);
        $download->public = 2;
        $download->save();
        Toastr::success('Notice Rejected Successfully');
        return redirect()->back();
    }


    //Admin DPT Result Reject
    public function PremissionNoticeAccept($id)
    {
        $download = NewsNotice::find($id);
        $download->public = 1;
        $download->save();
        Toastr::success('Notice Posted Successfully');
        return redirect()->back();
    }

    //Admin Gallery Premission
    public function PremissionGalleryView()
    {
        Session::put('admin_page', 'admin_gallery_view');
        $gallery = Gallery::latest()->get();
        return view('admin.premission.gallery_premission', compact('gallery'));
    }


    //Admin DPT Result Reject
    public function PremissionGalleryReject($id)
    {
        $download = Gallery::find($id);
        $download->public = 2;
        $download->save();
        Toastr::success('Gallery Rejected Successfully');
        return redirect()->back();
    }


    //Admin DPT Result Reject
    public function PremissionGalleryAccept($id)
    {
        $download = Gallery::find($id);
        $download->public = 1;
        $download->save();
        Toastr::success('Gallery Posted Successfully');
        return redirect()->back();
    }





    //Admin Gallery Premission
    public function PremissionEventView()
    {
        Session::put('admin_page', 'admin_gallery_view');
        $gallery = Gallery::latest()->get();
        return view('admin.premission.gallery_premission', compact('gallery'));
    }


    //Admin DPT Result Reject
    public function PremissionEventReject($id)
    {
        $download = Event::find($id);
        $download->public = 2;
        $download->save();
        Toastr::success('Gallery Rejected Successfully');
        return redirect()->back();
    }


    //Admin DPT Result Reject
    public function PremissionEventAccept($id)
    {
        $download = Event::find($id);
        $download->public = 1;
        $download->save();
        Toastr::success('Gallery Posted Successfully');
        return redirect()->back();
    }
}
