@extends('admin.admin_master')
@section('admin.admin_content')
<div class="container-xxl flex-grow-1 container-p-y">
    <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> About Update</h4>
    <div class="row">
        <div class="col-md-12">
            <div class="card mb-4">
                <div class="row">
                    <div class="col-6 col">
                        <h5 class="card-header">Update About</h5>
                    </div>
                </div>
                <!-- Account -->
                <hr class="my-0" />
                <div class="card-body">
                    <form id="formAccountSettings" method="POST" action="{{ route('admin.about_update_store') }}">
                        @csrf
                        <div class="row">

                            <div class="mb-3 col-md-12">
                                <label for="title" class="form-label">Page Heading <span class="text-danger">*</span></label>
                                <input class="form-control title_count" type="text" id="title" placeholder="About" name="title" value="{{ $about_update->title }}" />
                                @error('title')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                                <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                            </div>
                            <div class="mb-3 col-md-12">
                                <label for="about" class="form-label">Description <span class="text-danger">*</span></label>
                                <textarea name="about" class="form-control ckeditor" id="about" cols="30" rows="10">{{ $about_update->about }}</textarea>
                                @error('about')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        <div class="mt-2 float-end">
                            <button type="submit" class="btn btn-primary me-2">Update</button>
                            <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                        </div>
                </div>
                </form>
            </div>
            <!-- /Account -->
        </div>
    </div>
</div>
</div>
<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>

<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.ckeditor').ckeditor();
    });
</script>
<script>
    $(document).ready(function() {
        $('.title_count').on('input', function() {
            var inputLength = $(this).val().length;
            if (inputLength >= 100) {
                $('.characterCount').text(inputLength).css({
                    'color': 'red'
                });
            } else {
                $('.characterCount').text(inputLength).css({
                    'color': '#03ac1c'
                });
            }

        });
    });
</script>

@endsection