@extends('admin.admin_master')
@section('admin.admin_content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- ✅ load jQuery ✅ -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


<!-- ✅ load DataTables ✅ -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js" integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- Content -->
<section>

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> View Part Courses</h4>

        @php
        $i = 1;
        @endphp
        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">List Part Courses</h5>

                </div>

            </div>


            <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                <table class="table" id="exampleTable" width="100%">
                    <thead>
                        <tr class="text-nowrap">
                            <th>SN</th>
                            <th>Subject Code</th>
                            <th>Subject Name</th>
                            <th>Credit Hours</th>
                            <th>Action</th>
                        </tr>

                    </thead>
                    <tbody class="table-border-bottom-0">
                        @foreach ($course_subject_view as $course_subject_name)
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td>{{ $course_subject_name->subject_code }}</td>
                            <td>{{ $course_subject_name->subject_name }}</td>
                            <td>{{ $course_subject_name->subject_hours }}</td>
                            <td> @php
                                $user_auth = \Illuminate\Support\Facades\Auth::user();
                                @endphp
                                @if($user_auth->admin_type == "Author User")
                                <a data-bs-toggle="modal" data-bs-target="#basicModal{{ $course_subject_name->id }}" class="btn btn-primary text-white">Edit</a> <a href="{{ route('admin.course_part_subject_delete', $course_subject_name->id) }}" class="btn btn-danger" id="deleteData">Delete</a>
                                @else
                                <span class="text-danger">Action connot access</span>
                                @endif
                            </td>
                        </tr>
                        <div class="modal fade" id="basicModal{{ $course_subject_name->id }}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel1">Add New Course</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('admin.course_part_update_subject',$course_subject_name->id) }}" method="POST">
                                        @csrf
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col mb-3">
                                                    <label for="nameBasic" class="form-label">Course Name</label>
                                                    <select name="course_id" class="form-control" id="course_id">
                                                        <option value="">Select Course </option>
                                                        @foreach ($course_view as $course_name)
                                                        <option value="{{ $course_name->id }}" {{ $course_name->id == $course_subject_name->course_id ? 'selected' : '' }}>
                                                            {{ $course_name->course_name }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    @error('course_id')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="row g-2 mb-3">
                                                <div class="col mb-0">
                                                    <label for="emailBasic" class="form-label">Course Part
                                                        Name</label>
                                                    <select name="course_part_id" class="form-control" id="course_part_id">
                                                        <option value="">Select Course </option>
                                                        @foreach ($course_details as $course_parts)
                                                        <option value="{{ $course_parts->id }}" {{ $course_parts->id == $course_subject_name->course_part_id ? 'selected' : '' }}>
                                                            {{ $course_parts->course_part }}
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    @error('course_id')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>

                                            </div>

                                            <div class="g-2 mb-3">
                                                <div class="col mb-0">
                                                    <label for="emailBasic" class="form-label">Subject Code
                                                    </label>
                                                    <input type="text" id="subject_code" class="form-control" name="subject_code" placeholder="ICT-232CT" value="{{ $course_subject_name->subject_code }}" />
                                                    @error('subject_code')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>

                                            </div>
                                            <div class="row g-2 mb-3">
                                                <div class="col mb-0">
                                                    <label for="subject_name" class="form-label">Subject
                                                        Name</label>
                                                    <input type="text" id="subject_name" class="form-control title_count" name="subject_name" placeholder="IT Fundamentals" value="{{ $course_subject_name->subject_name }}" />
                                                    @error('subject_name')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                    <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                                                </div>
                                            </div>
                                            <div class="row g-2">
                                                <div class="col mb-0">
                                                    <label for="subject_hours" class="form-label">Credit Hour
                                                    </label>
                                                    <input type="text" id="subject_hours" class="form-control" name="subject_hours" placeholder="3" value="{{ $course_subject_name->subject_hours }}" />
                                                    @error('subject_hours')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>

                                            </div>

                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                                Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Basic Bootstrap Table -->
    </div>


</section>

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script type="text/javascript">
    $(function() {
        $(document).on('change', '#course_id', function() {
            var course_id = $('#course_id').val();
            $.ajax({
                url: "{{ route('admin.course_part_subject_ajax') }}",
                type: "get",
                data: {
                    course_id: course_id
                },
                success: function(data) {
                    var html = '<option value="">Select Part Course</option>';
                    $.each(data, function(key, v) {
                        html += '<option value="' + v.id + '">' + v
                            .course_part + '</option>';
                    });
                    $('#course_part_id').html(html);
                }
            });
        });
    });
</script>
<script>
    $(document).ready(function() {
        $.noConflict();
        $('#exampleTable').DataTable();
    });
</script>
@endsection