@extends('admin.admin_master')
@section('admin.admin_content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- ✅ load jQuery ✅ -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


<!-- ✅ load DataTables ✅ -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js" integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- Content -->
<section>

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span> Quick Access Links</h4>

        @php
        $i = 1;
        @endphp
        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">List Links</h5>

                </div>
                <div class="col-6 col card-header">
                    <a data-bs-toggle="modal" data-bs-target="#basicModal" class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New Item</a>
                </div>
            </div>


            <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                <table class="table" id="exampleTable" width="100%">
                    <thead>
                        <tr class="text-nowrap">
                            <th>SN</th>
                            <th>Logo</th>
                            <th>Access Name</th>
                            <th>Links</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        @foreach ($quickaccess as $access)
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td><img src="{{asset($access->logo)}}" alt="" height="30px"></td>
                            <td>{{ $access->name }}</td>
                            <td>{{ $access->link }}</td>

                            <td>@php
                                $user_auth = \Illuminate\Support\Facades\Auth::user();
                                @endphp
                                @if($user_auth->admin_type == "Author User")
                                <a data-bs-toggle="modal" data-bs-target="#basicModal{{ $access->id }}" class="btn btn-primary text-white">Edit</a> <a href="{{ route('admin.footer_quick_access_delete', $access->id) }}" id="deleteData" class="btn btn-danger">Delete</a>
                                @else
                                <span class="text-danger">Action connot access</span>
                                @endif
                            </td>
                        </tr>
                        <!-- Modal -->
                        <div class="modal fade" id="basicModal{{$access->id}}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel1">Edit Quick Access Name</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{ route('admin.footer_quick_access_update',$access->id) }}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col mb-3">
                                                    <label for="nameBasic" class="form-label">Quick Access Name</label>
                                                    <input type="text" id="name" class="form-control title_count" name="name" placeholder="CTEVT" value="{{$access->name}}" />
                                                    @error('name')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                    <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                                                </div>
                                            </div>
                                            <div class="row g-2 mb-3">
                                                <div class="col-12 mb-0">
                                                    <label for="emailBasic" class="form-label">Quick Access Links</label>
                                                    <input type="text" id="link" class="form-control" name="link" value="{{$access->link}}" placeholder="http://ctevt.org.np/" />
                                                    @error('course_duration')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>

                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <label for="logo" class="form-label">Logo <span class="text-danger">*</span></label>
                                                <input type="file" class="form-control" name="logo" multiple="" id="logo" onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                                @error('logo')
                                                <p class="text-danger">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="mb-3 col-md-12">
                                                <img src="{{asset($access->logo)}}" height="50px" class="adminProImg" alt="">
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                                Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Update</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Basic Bootstrap Table -->
    </div>
    <!-- / Content -->

    <!-- Modal -->
    <div class="modal fade" id="basicModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel1">Add Quick Access Name</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ route('admin.footer_quick_access_store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col mb-3">
                                <label for="nameBasic" class="form-label">Quick Access Name</label>
                                <input type="text" id="name" class="form-control title_count" name="name" placeholder="CTEVT" />
                                @error('name')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                                <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>
                            </div>
                        </div>
                        <div class="row g-2 mb-3">
                            <div class="col-12 mb-0">
                                <label for="emailBasic" class="form-label">Quick Access Links</label>
                                <input type="text" id="course_duration" class="form-control" name="link" placeholder="http://ctevt.org.np/" />
                                @error('course_duration')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>

                        </div>
                        <div class="mb-3 col-md-6">
                            <label for="logo" class="form-label">Logo <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" name="logo" multiple="" id="logo" onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                            @error('logo')
                            <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="mb-3 col-md-12">
                            <img src="" class="adminProImg" alt="">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>


</section>
<script>
    $(document).ready(function() {
        $.noConflict();
        $('#exampleTable').DataTable();
    });
</script>


<script>
    function mainProImgUrl(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('.adminProImg').attr('src', e.target.result).width(80).height(80);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endsection