@extends('admin.admin_master')
@section('admin.admin_content')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/css/jquery.dataTables.min.css" integrity="sha512-1k7mWiTNoyx2XtmI96o+hdjP8nn0f3Z2N4oF/9ZZRgijyV4omsKOXEnqL1gKQNPy2MTSP9rIEWGcH/CInulptA==" crossorigin="anonymous" referrerpolicy="no-referrer" />

<!-- ✅ load jQuery ✅ -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.13.1/css/jquery.dataTables.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.1/jquery.min.js" integrity="sha512-aVKKRRi/Q/YV+4mjoKBsE4x3H+BkegoM/em46NNlCqNTmUYADjBbeNefNxYV7giUp0VxICtqdrbqU7iVaeZNXA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>


<!-- ✅ load DataTables ✅ -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/datatables/1.10.21/js/jquery.dataTables.min.js" integrity="sha512-BkpSL20WETFylMrcirBahHfSnY++H2O1W+UnEEO4yNIl+jI2+zowyoGJpbtk6bx97fBXf++WJHSSK2MV4ghPcg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-- Content -->
<section>

    <div class="container-xxl flex-grow-1 container-p-y">
        <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Dashboard /</span>Create New Testimonial</h4>

        @php
        $i = 1;
        @endphp
        <!-- Basic Bootstrap Table -->
        <div class="card">
            <div class="row">
                <div class="col-6 col">
                    <h5 class="card-header">List Testimonials</h5>

                </div>
                <div class="col-6 col card-header">
                    <a data-bs-toggle="modal" data-bs-target="#basicModal" class="float-end btn btn-primary text-nowrap add-new-role text-white">Add New Testimonial</a>
                </div>
            </div>


            <div class="table-responsive text-nowrap pe-3 ps-3 pb-3">
                <table class="table" id="exampleTable" width="100%">
                    <thead>
                        <tr class="text-nowrap">
                            <th>SN</th>
                            <th>Name</th>
                            <th>User Classify</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        @foreach ($testimonial_view as $testimonial)
                        <tr>
                            <td>{{ $i++ }}</td>
                            <td>{{ $testimonial->user_name }}</td>
                            <td>{{ $testimonial->user_type }}</td>
                            <td><a data-bs-toggle="modal" data-bs-target="#basicModal{{ $testimonial->id }}" class="btn btn-primary text-white">Edit</a> <a href="{{ route('admin.testimonail_delete', $testimonial->id) }}" id="deleteData" class="btn btn-danger">Delete</a></td>
                        </tr>
                        <!-- Modal -->
                        <div class="modal fade" id="basicModal{{$testimonial->id}}" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel1">Edit Testimonial</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <form action="{{route('admin.testimonail_update',$testimonial->id)}}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col mb-3">
                                                    <label for="nameBasic" class="form-label">User Name</label>
                                                    <input type="text" id="user_name" class="form-control" value="{{ $testimonial->user_name }}" name="user_name" placeholder="Sushil K.C." />
                                                    @error('name')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="row g-2">
                                                <div class="col-12 mb-3">
                                                    <label for="emailBasic" class="form-label">User Types</label>
                                                    <input type="text" id="user_type" class="form-control" value="{{ $testimonial->user_type }}" name="user_type" placeholder="Teacher, Student" />
                                                    @error('user_type')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                                <div class="col-12 mb-3">
                                                    <label for="dobBasic" class="form-label">Message</label>
                                                    <textarea name="message" id="message" cols="30" class="form-control" rows="10">{{ $testimonial->message }}</textarea>
                                                    @error('message')
                                                    <p class="text-danger">{{ $message }}</p>
                                                    @enderror
                                                </div>
                                            </div>

                                            <h5 class="fw-bold py-3 mb-3">User Image </h5>
                                            <div class="mb-3 col-md-12">
                                                <label for="image" class="form-label">Image <span class="text-danger">*</span></label>
                                                <input type="file" class="form-control" id="image" name="image" onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                                                @error('image')
                                                <p class="text-danger">{{ $message }}</p>
                                                @enderror
                                            </div>
                                            <div class="mb-3 col-md-6">
                                                <img src="{{asset($testimonial->image)}}" class="img-fluid" height="100px" alt="" id="adminProImg">
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                                                Close
                                            </button>
                                            <button type="submit" class="btn btn-primary">Update Testimonial</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Basic Bootstrap Table -->
    </div>
    <!-- / Content -->

    <!-- Modal -->
    <div class="modal fade" id="basicModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel1">Add Testimonial</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{route('admin.testimonail_store')}}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col mb-3">
                                <label for="nameBasic" class="form-label">User Name</label>
                                <input type="text" id="user_name" class="form-control title_count" name="user_name" placeholder="Sushil K.C." />
                                @error('name')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                                <span class="characterCount" style="font-size: 12px;"></span> <span style="font-size: 12px;">Enter Only 100 Characters </span>

                            </div>
                        </div>
                        <div class="row g-2">
                            <div class="col-12 mb-3">
                                <label for="emailBasic" class="form-label">User Types</label>
                                <input type="text" id="user_type" class="form-control" name="user_type" placeholder="Teacher, Student" />
                                @error('user_type')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                            <div class="col-12 mb-3">
                                <label for="dobBasic" class="form-label">Message</label>
                                <textarea name="message" id="message" cols="30" class="form-control" rows="10"></textarea>
                                @error('message')
                                <p class="text-danger">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <h5 class="fw-bold py-3 mb-3">User Image </h5>
                        <div class="mb-3 col-md-12">
                            <label for="image" class="form-label">Image <span class="text-danger">*</span></label>
                            <input type="file" class="form-control" id="image" name="image" onchange="mainProImgUrl(this)" accept="image/png, image/jpeg" />
                            @error('image')
                            <p class="text-danger">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="mb-3 col-md-6">
                            <img src="" alt="" id="adminProImg">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                            Close
                        </button>
                        <button type="submit" class="btn btn-primary">Add Testimonial</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

</section>
<script>
    $(document).ready(function() {
        $.noConflict();
        $('#exampleTable').DataTable();
    });
</script>
<!-- / Content -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    function mainProImgUrl(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#adminProImg').attr('src', e.target.result).width(80).height(80);
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
</script>
@endsection