@extends('user.user_master')
@section('user.user_content')
@php
$theme = \App\Models\Theme::find(1);

@endphp
@section('user_title')
Contact - Madhyamik Bidhyalaya Tulsipur Center
@endsection
<style>
    .row{
        padding-left: none!important;
        padding-right: none!important;
    }
</style>
<div  style="background-color: #f0f5fb;">
<section>
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($theme->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Contact', 'ne') }} @else Contact Us @endif</h1>
                    <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Success is not the key to happiness. Happiness is the key to success.', 'ne') }} @else Success is not the key to happiness. Happiness is the key to success. @endif</span>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="mb-4 mt-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-12 contact">
                <div class="row">
                    <div class="col-md-12">
                        <div class="info-box border bg-white">
                            <i class="bi bi-map"></i>
                            <h3>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Address', 'ne') }} @else Our Address @endif</h3>
                            <p>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($theme->address, 'ne') }} @else {{$theme->address}} @endif </p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-box border mt-4 bg-white">
                            <i class="bi bi-envelope"></i>
                            <h3>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Email', 'ne') }} @else E-mail @endif</h3>
                            <p><a class="text-dark" href="https://mail.google.com/mail/u/1/?view=cm&fs=1&to={{$theme->email}}&tf=1">
                                @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($theme->email, 'ne') }} @else {{$theme->email}} @endif</a></p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="info-box border mt-4 bg-white">
                            <i class="bi bi-telephone-fill"></i>
                            <h3>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Phone Number', 'ne') }} @else Phone Number @endif</h3>
                            <p><a class="text-dark" href="tel:{{$theme->telephone}}">
                                @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($theme->telephone, 'ne') }} @else {{$theme->telephone}} @endif </a></p>
                        </div>
                    </div>
                </div>

            </div>

            <div class=" col-lg-6 col-12 mt-3 mt-lg-0 contact-form">
                <form action="{{ route('send.email') }}" id="contact-frm" method="post" class="bg-white">
                    @csrf
                    <input type="hidden" id="token" value="{{ @csrf_token() }}">
                    <div id="res"></div>
                    <div class="p-4 rounded border">
                        <div class="row">
                            <div class="col-lg-6 col-12">
                                <div>
                                    <input type="text" name="name" id="name" class="form-control" placeholder="Your Name" required>
                                </div>
                            </div>
                            <div class="col-lg-6 mt-3 col-12 mt-lg-0">
                                <div class="">
                                    <input type="text" name="email" id="email" class="form-control" placeholder="Your Email" required>
                                </div>
                            </div>
                        </div>
                        <div class="mt-3">
                            <input type="text" name="subject" id="subject" class="form-control" placeholder="Subject" required>
                        </div>
                        <div class="mt-3 mb-3">
                            <textarea name="message" cols="20" rows="6" id="content" class="form-control" placeholder="Message"></textarea>
                        </div>
                        <button type="submit" id="btn" class="btn btn-arrow-right read-more" href="#">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Send Message', 'ne') }} @else Send Message @endif <i class="bi bi-send-fill"></i></button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</section>

<section data-aos="flip-down" data-aos-easing="ease-out-cubic" data-aos-duration="2000">
    <div class="container">
        <iframe style="border: 1px solid red!important;" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1759.360971185479!2d82.29593395635959!3d28.124502682620946!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3997f4815a9dc225%3A0x63ad2a2695a7b6fa!2sSecondary%20School%20Tulsipur%20Center!5e0!3m2!1sen!2snp!4v1674918729333!5m2!1sen!2snp" height="400" width="100%" style="border:0;" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
    </div>
</section>
</div>
<!-- Start Contact Area -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.js" integrity="sha512-n/4gHW3atM3QqRcbCn6ewmpxcLAHGaDjpEBu4xZd47N0W2oQ+6q7oc3PXstrJYXcbNU1OHdQ1T7pAP+gi5Yu8g==" crossorigin="anonymous"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@10"></script>

<script>
    $(document).ready(function() {
        $("#contact-frm").submit(function(e) {
            e.preventDefault();
            let url = $(this).attr('action');
            $("#btn").attr('disabled', true);
            $.post(url, {
                    '_token': $("#token").val(),
                    email: $("#email").val(),
                    name: $("#name").val(),
                    content: $("#content").val(),
                    subject: $("#subject").val(),
                    phone: $("#phone").val(),
                },

                function(response) {
                    if (response.code == 400) {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: response.msg,
                        })
                    } else if (response.code == 200) {
                        const Toast = Swal.fire({
                            icon: 'success',
                            title: 'Successfully Send!',
                            text: response.msg,
                        })
                    }
                    $("#email").val(''),
                        $("#name").val(''),
                        $("#content").val(''),
                        $("#subject").val(''),
                        $("#phone").val('')
                });
        })
    })
</script>

@endsection