@extends('user.user_master')
@section('user.user_content')
@section('user_title')
News & Notice - {{$events_details->event_title}}
@endsection
@php
$images = \App\Models\Theme::find(1);
@endphp
<!-- Page Content -->
<div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
    <div class="container page-opacity">
        <div class="row">
            <div class="col-md-12">
                <h1> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Events Details', 'ne')  }} @else Events Details @endif</h1>
                <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('In learning you will teach, and in teaching you will learn.', 'ne')  }} @else In learning you will teach, and in teaching you will learn. @endif</span>
            </div>
        </div>
    </div>
</div>
</section>


<section class="section-box mt-50 mt-5 mb-5">
    <div class="post-loop-grid">
        <div class="container">

            <div class="row mt-30">
                <div class="col-lg-8">

                    <div class=" post">
                        <div class="card-header">
                            <h1> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($events_details->event_title, 'ne')  }} @else {{$events_details->event_title}} @endif</h1>
                        </div>
                        <div class="card-body">
                            <div class="contain">
                                <div class="row mb-3 ">
                                    <div class="col-md-4 col-12">
                                        <p><strong>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Published By:', 'ne')  }} @else Published By: @endif</strong> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($events_details->user->name, 'ne')  }} @else {{$events_details->user->name}}  @endif</p>
                                    </div>
                                    <div class="col-md-4 text-lg-center text-start col-12">
                                        <p><strong>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Event Location:', 'ne')  }} @else Event Location: @endif</strong> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($events_details->location, 'ne')  }} @else  {{$events_details->location}}  @endif</p>
                                    </div>
                                    <div class="col-md-4 text-lg-end col-12 text-start">
                                        <p> <strong>Date:</strong> @php
                                            $year = $events_details->created_at->format('Y');
                                            $month = $events_details->created_at->format('m');
                                            $day = $events_details->created_at->format('d');
                                            $date = Bsdate::eng_to_nep($year, $month, $day);
                                            echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year']
                                            @endphp</p>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <div class="notice-image">
                                    @php
                                    $notice_image = \App\Models\EventImage::where('event_id',$events_details->id)->get();
                                    @endphp
                                    @foreach($notice_image as $item)
                                    <img class="img-fluid mb-3" src="{{asset($item->image)}}" alt="">
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="disqus_thread"></div>
                        <script>
                            (function() {
                                var d = document,
                                    s = d.createElement('script');
                                s.src = 'https://print-house-websote.disqus.com/embed.js';
                                s.setAttribute('data-timestamp', +new Date());
                                (d.head || d.body).appendChild(s);
                            })();
                        </script>
                        <noscript>Please enable JavaScript to view the <a href="https://disqus.com/?ref_noscript">comments powered by Disqus.</a></noscript>
                </div>
                <div class="col-lg-4 col-md-12 mt-5 col-sm-12 col-12 pl-40 pl-lg-15 mt-lg-0">

                <div class="sidebar-shadow sidebar-news-small card p-3">
                        <h5 class="sidebar-title">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Related Events', 'ne')  }} @else Related Events @endif </h5>
                        <hr>
                        @foreach($related_notice as $notice)
                        @php
                        $notice_image = \App\Models\NewsNoticeImage::where('event_id',$notice->id)->first();
                        @endphp
                        <div class="post-list-small mb-1" style="margin-bottom: 1px dashed #585858;">
                            <div class="post-list-small-item d-flex align-items-center">
                                <figure class="thumb"><img src="{{asset($notice_image->image)}}" alt="jobBox" height="70px" width="40px" class="me-3 mt-4"></figure>
                                <div class="content" style="margin-bottom: -10px!important;">
                                    <a href="{{url('/news-notice-details',$notice->id.'/'.$notice->notice_title)}}">
                                        <h5>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($notice->event_title, 'ne')  }} @else {{$notice->event_title}}  @endif</h5>
                                    </a>
                                    <div class="row">
                                        <div class="col-6">
                                            <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($notice->user->name, 'ne')  }} @else {{$notice->user->name}}  @endif</span>
                                        </div>
                                        <div class="col-6">
                                            <span> @php
                                                $year = $notice->created_at->format('Y');
                                                $month = $notice->created_at->format('m');
                                                $day = $notice->created_at->format('d');
                                                $date = Bsdate::eng_to_nep($year, $month, $day);
                                                echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year']
                                                @endphp</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection