@extends('user.user_master')
@section('user.user_content')
@section('user_title')
Gallery Details - Gallery Images
@endsection
@php
$images = \App\Models\Theme::find(1);
@endphp
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.3/jquery.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css" integrity="sha512-H9jrZiiopUdsLpg94A333EfumgUBpO9MdbxStdeITo+KEIMaNfHNvwyjjDJb+ERPaRS6DpyRlKbvPUasNItRyw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js" integrity="sha512-uURl+ZXMBrF4AwGaWmEetzrd+J5/8NRkWAvJx5sbPSSuOb0bZLqf+tOzniObO00BjHa/dD7gub9oCGMLPQHtQA==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!-------Page Content Start------->
<section class="mb-4">
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Gallery Details', 'ne') }} @else Gallery Details @endif</h1>
                    <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Education is not preparation for life; education is life itself.', 'ne') }} @else Education is not preparation for life; education is life itself. @endif</span>
                </div>
            </div>
        </div>
    </div>
</section>
<!-------Page Content End------->
<section>
    <div class="location-house ">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12  mb-3">

                    <div class="section-tittle text-center mt-5 text-primary-1">
                        <h2 style="font-size: 24px; font-weight:bold;"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($gallery->title, 'ne') }} @else {{$gallery->title}} @endif
                        </h2>
                        <hr>
                    </div>
                </div>
            </div>
        </div>

        <div class="container work">
            <div class="row">
                <div class="col-md-9">
                    <div class="row mt-5">
                        <?php
                        $gallery_image = \App\Models\GalleryImage::where('gallery_id', $gallery->id)->get();
                        ?>
                        @foreach($gallery_image as $item)
                        <div class="col-lg-6 col-md-6 work-portfolio-item ">
                            <div class="single-project project mb-3 ">
                                <a href="{{asset($item->image)}}" class="fancybox" data-fancybox="image1"><img src="{{asset($item->image)}}" class="img-fluid"></a>

                            </div>
                        </div>
                        @endforeach


                        <div id="disqus_thread"></div>
                        <script>
                            (function() {
                                var d = document,
                                    s = d.createElement('script');
                                s.src = 'https://print-house-websote.disqus.com/embed.js';
                                s.setAttribute('data-timestamp', +new Date());
                                (d.head || d.body).appendChild(s);
                            })();
                        </script>
                        <noscript>Please enable JavaScript to view the <a href="https://disqus.com/?ref_noscript">comments powered by Disqus.</a></noscript>
                    </div>
                </div>
                <div class="col-md-3">
                    <aside class="widget-area">
                        <section class="widget widget_latest_news_thumb text-dark">
                            <h3 class="widget-title text-primary-1">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Other Images', 'ne') }} @else Other Images @endif 
                            </h3>
                            <?php
                            $gallery = \App\Models\Gallery::where('id', '!=', $gallery->id)->get();
                            ?>
                            @foreach($gallery as $item)
                            @php
                            $gallery_image = \App\Models\GalleryImage::where('gallery_id', $item->id)->first();
                            @endphp
                            <article class="item">
                                <a href="#" class="thumb">
                                    <span class="fullimage cover bg1" role="img"><img class="img-fluid" style="height: 100px!important;" src="{{asset($gallery_image->image)}}" alt=""></span>
                                </a>
                                <div class="info">
                                    <span class="title usmall" style="font-size: 18px;"><a href="http://suryodayaprint.com.np/work_details/17"> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans(\Illuminate\Support\Str::limit($item->title, 40), 'ne') }} @else {{\Illuminate\Support\Str::limit($item->title, 40)}} @endif
                                        </a></span>
                                   <div class="row">
                                    <div class="col-md-6">
                                    <span style="font-family: Barlow, sans-serif">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($item->user->name, 'ne') }} @else {{$item->user->name}}  @endif</span>
                                    </div>
                                    <div class="col-md-6">
                                    <span style="font-family: Barlow, sans-serif">@php
                                                        $year = $item->created_at->format('Y');
                                                        $month = $item->created_at->format('m');
                                                        $day = $item->created_at->format('d');
                                                        $date = Bsdate::eng_to_nep($year, $month, $day);
                                                        echo $date['nmonth'] . ' ' . $date['date'] .','. ' ' . $date['year'];
                                                        @endphp</span>
                                    </div>
                                   </div>
                                
                                </div>
                            </article>
                            @endforeach

                        </section>
                    </aside>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection