@extends('user.user_master')
@section('user.user_content')
@section('user_title')
Gallery - Lists of Gallery
@endsection
@php
$images = \App\Models\Theme::find(1);
@endphp
<section class="mb-4">
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Gallery', 'ne') }} @else Gallery @endif</h1>
                    <span>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Education is the passport to the future', 'ne') }} @else Education is the passport to the future @endif</span>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Projects Start -->
<section>
    <div class="container-xxl mb-5 mt-5">
        <div class="container">
            <div class="row portfolio-container">

                @foreach($gallery as $item)
                @php
                $gallery_image = \App\Models\GalleryImage::where('gallery_id',$item->id)->first();
                @endphp
                <div class="col-lg-4 col-md-4 mt-3 portfolio-item">
                    <div class="rounded overflow-hidden gallery border">
                        <div class="position-relative overflow-hidden ">
                            <img src="{{asset($gallery_image->image)}}" alt="" width="100%" height="250px">
                            <div class="portfolio-overlay">
                                <a class="btn btn-square btn-outline-light" href="{{url('gallery-details',$item->id.'/'.$item->title_slug)}}"><i class="bi bi-link text-white"></i></a>
                            </div>
                        </div>
                        <div class="bg-light p-4">
                            <a href="{{url('gallery-details',$item->id.'/'.$item->title_slug)}}">
                                <p class="lh-base mb-0 text-dark" style="font-size: 17px;">
                                @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans(\Illuminate\Support\Str::limit($item->title, 40), 'ne') }} @else {{\Illuminate\Support\Str::limit($item->title, 40)}} @endif 
                                </p>
                            </a>
                        </div>
                    </div>
                </div>
                @endforeach

            </div>
            <div class="col-lg-12 col-md-12 col-sm-12">
                <nav aria-label="Page navigation example" class="mt-5 mb-5">
                    <ul class="pagination justify-content-center" style="font-family: 'Titillium Web', sans-serif;">
                        <div style="box-shadow: 0px 4px 4px 4px rgb(231, 230, 230);display: flex;">
                            {{$gallery->links()}}
                        </div>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- Projects End -->


@endsection