@extends('user.user_master')
@section('user.user_content')
@section('user_title')
Result - Result Details
@endsection
@php
$images = \App\Models\Theme::find(1);
@endphp
<section>
    <!-- Page Content -->
    <div class="page-heading header-text" style="background-image: url('{{asset($images->image)}}');">
        <div class="container page-opacity">
            <div class="row">
                <div class="col-md-12">
                    <h1>@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Results Details ', 'ne')  }} @else Results Details  @endif</h1>
                    <span> @if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans('Education is the most powerful weapon which you can use to change the world.', 'ne')  }} @else Education is the most powerful weapon which you can use to change the world. @endif</span>
                </div>
            </div>
        </div>
    </div>
</section>


<section class="section-department mt-5 mb-5 ">
    <div class="intro">
        <div class="bg-image h-100">
            <div class="mask d-flex align-items-center">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-12">
                            <div class="card">
                                <div class="card-body p-0">
                                    <div class="table-responsive" data-mdb-perfect-scrollbar="true" style="position: relative;">
                                        <table class="table table-striped mb-0">

                                            <thead>
                                                <tr>
                                                    <th colspan="5" class="bg-primary-color">
                                                        <p class="bg-primary-color p-2" style=" margin-bottom: -1px;">@if(session()->get('language') == 'nepali') {{ \Stichoza\GoogleTranslate\GoogleTranslate::trans($down->title, 'ne') }} @else {{$down->title}} @endif</p>
                                                    </th>

                                                </tr>
                                               
                                            </thead>
                                                @foreach($downloads as $key=>$results)
                                                <tr>
                                                    <td>
                                                        @php
                                                        $path = $results->file;
                                                        $fileName = pathinfo($path, PATHINFO_FILENAME);
                                                        @endphp
                                                        <a href="{{route('user.result_view',$results->id)}}"><i class="bi bi-file-earmark-pdf-fill me-2"></i> {{$fileName}}.pdf</a>
                                                    </td>
                                                    <td><a href="{{route('user.result_download',$results->id)}}">Download</a></td>
                                                </tr>
                                                @endforeach



                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection